
var Black  = CreateColor(0, 0, 0);
var DarkGray = CreateColor(25, 25, 25);
var Red = CreateColor(200, 0, 0);
var White = CreateColor(255, 255, 255);
var DarkCyan = CreateColor(125, 255, 100);

RequireScript("Waffle.js");
RequireScript("Cursor.js");
RequireScript("DynaImage.js");
RequireScript("Textbox.js");
RequireScript("Menu.js");
RequireScript("Modes.js");
RequireScript("input.js");
RequireSystemScript("screen.js");

const SW = GetScreenWidth(), SH = GetScreenHeight();

var font = LoadFont("system.rfn");
var BGcolor = CreateColor(220, 168, 86);
Rectangle(0, 0, SW, SH, BGcolor);
font.drawZoomedText(SW/2-font.getStringWidth("LOADING..."), SH/2-8, 2, "LOADING...");
font.drawText(SW/2-font.getStringWidth("IMAGES")/2, SH/2+16, "IMAGES");
FlipScreen();

var BG1 = new DynaImage("BG1.png");
BG1.fadeImage("out");
BG1.looped = true;
BG1.loopFade = true;
var BG2 = new DynaImage("BG2.png");
BG2.fadeImage("in");
BG2.looped = true;
BG2.loopFade = true;
var Screen = LoadImage("Screen.png");
var Radnen = new DynaImage("Radnen.png");
Radnen.color.alpha = 0;
var Sphere = new DynaImage("Sphere.png");
Sphere.color.alpha = 0;
var CreditPlane = new DynaImage("CreditPlane.png");
CreditPlane.addText(100, 24, font, "Credits:", 2);
CreditPlane.addText(110, 50, font, "Design - Radnen");
CreditPlane.addText(110, 60, font, "Graphics - Radnen");
CreditPlane.addText(110, 70, font, "Code - Radnen");
CreditPlane.addText(110, 80, font, "Music - The Mod Archive");
CreditPlane.addText(100, 104, font, "Contact:", 2);
CreditPlane.addText(SW/2-font.getStringWidth("Andrew Helenius - Radnen@gmail.com")/2, 130, font, "Andrew Helenius - Radnen@gmail.com");
CreditPlane.addText(SW/2-font.getStringWidth("Thanks Spherical for Playing!")/2, 150, font, "Thanks Spherical for playing!");
CreditPlane.addText(SW/2-font.getStringWidth("Press Escape To Go Back.")/2, 170, font, "Press Escape To Go Back.");
var Squared = LoadImage("Squared.png");
var ButtonImage = LoadImage("Button.png");
var ButtonOverImage = LoadImage("ButtonOver.png");
var BigButtonImage = LoadImage("BigButton.png");
var BigButtonOverImage = LoadImage("BigButtonOver.png");
var window = LoadWindowStyle("GameWindow.rws");
var TextArrow = LoadImage("TextArrow.png");

var Selector = LoadImage("Selector.png");
var PrIcon = LoadImage("PracticeIcon.png");
var RgIcon = LoadImage("RandomGameIcon.png");
var ArIcon = LoadImage("ArcadeIcon.png");
var PsIcon = LoadImage("PrecisionIcon.png");
var GameModes = [PrIcon, RgIcon, ArIcon, PsIcon];
var G_moves = 4;

var Mode1 = "Play The Practice Mode";
var Mode2 = "Play A Random Game";
var Mode3 = "Play The Aracde Mode";
var Mode4 = "Play The Precision Mode";
var GameModeTexts = [Mode1, Mode2, Mode3, Mode4];

Rectangle(0, 0, SW, SH, BGcolor);
font.drawZoomedText(SW/2-font.getStringWidth("LOADING..."), SH/2-8, 2, "LOADING...");
font.drawText(SW/2-font.getStringWidth("MUSIC")/2, SH/2+16, "MUSIC");
FlipScreen();
var title_song = LoadSound("squared.xm");

var GameMenu = new Menu(SW/2-40, SH/2-20, 80);
GameMenu.appendChoice("Play Game", DrawGameModes, White, Red);
GameMenu.appendChoice("Tutorial", Tutorial, White, Red);
GameMenu.appendChoice("Credits", Credits, White, Red);
GameMenu.appendChoice("Quit", Exit, White, Red);
GameMenu.preRender = function()
{
	BG1.update(2000);
	BG2.update(2000);
	Screen.blit(0, 0);
	Squared.blit(SW/2-Squared.width/2, 48);
}

RequireScript("Games.js");

var ArcadeMenu = new Menu(SW/2-80, SH/2-40, 160);
ArcadeMenu.setHeight(42);
ArcadeMenu.setMaxHeight(3);
var GameNumbers = [];
for (var i = 0; i < GameIcons.length; ++i)
{
	GameNumbers[i] = i;
	ArcadeMenu.appendChoice("Arcade Level: " + i,i, White, Red, GameIcons[i]);
}
ArcadeMenu.preRender = function()
{
	BG2.update(2000);
	BG1.update(2000);
	Screen.blit(0, 0);
	Squared.blit(SW/2-Squared.width/2, 48);
}

function game()
{
	title_song.play(true);
	Intro();
	GameMenu.draw();
}

function GamePlay()
{
	while (true)
	{
		var size = 0;
		while (true)
		{
			GradientRectangle(0, 0, SW, SH, Black, Black, Red, Red);
			window.drawWindow(SW/2-font.getStringWidth("Waffle size: 00")/2, SH/2-8, font.getStringWidth("Waffle size: 00"), 16);
			font.drawText(SW/2-font.getStringWidth("Waffle size: 00")/2, SH/2-8, "Waffle size: ");
			size = GetString(SW/2-font.getStringWidth("Waffle size: 00")/2+font.getStringWidth("Waffle size: "), SH/2-8, font, 1);
			if (size > 2 && size <= 9) break;
		}
		var GameWaffle = new Waffle(size);
		GameWaffle.generateField(8);
		GameWaffle.title = "Random Game";
		GameWaffle.preRender = function() { BG2.blit(0, 0); }
		GameWaffle.postRender = DoMouse;
		GameWaffle.display(SW/2-GameWaffle.width/2, SH/2-GameWaffle.height/2);
		GradientRectangle(0, 0, SW, SH, Black, Black, Red, Red);
		window.drawWindow(SW/2-font.getStringWidth("Waffle size: 00")/2, SH/2-8, font.getStringWidth("Waffle size: 00"), 16);
		font.drawText(SW/2-font.getStringWidth("Waffle size: 00")/2, SH/2-8, "Waffle size: ");
	}
}

function DoMouse()
{
	Cursor.handleUnPress();
	Cursor.draw();
}

function Intro()
{
	Rectangle(0, 0, SW, SH, BGcolor);
	BG1.fadeIn(1800);
	Radnen.setXY(SW/2-Radnen.width/2, SH/2-Radnen.height/2);
	Radnen.fadeIn(1300);
	BG2.fadeIn(1300);
	Sphere.setXY(SW/2-Sphere.width/2, SH/2-Sphere.height/2);
	Sphere.fadeIn(1300);
	BG1.fadeIn(1300);
}

function FrameWait(msecs)
{
	var bg = GrabImage(0, 0, SW, SH);
	var start = GetTime();
	while(start+msecs > GetTime())
	{
		bg.blit(0, 0);
		FlipScreen();
	}
	bg.blit(0, 0);
}

function DrawGameModes()
{
	var selection = 0;
	while(!IsKeyPressed(KEY_ESCAPE))
	{
		BG1.update(2000);
		BG2.update(2000);
		Screen.blit(0, 0);
		Squared.blit(SW/2-Squared.width/2, 48);
		window.drawWindow(SW/2-96, SH/2-24, 192, 48);
		window.drawWindow(SW/2-96, SH/2+32, 192, 8);
		font.drawText(SW/2-96, SH/2+30, GameModeTexts[selection]);
		for (var i = 0; i < 4; ++i) GameModes[i].blit(SW/2-96+i*48, SH/2-24);
		Selector.blit(SW/2-96+selection*48, SH/2-24);
		FlipScreen();
		while(AreKeysLeft())
		{
			switch (GetKey())
			{
				case KEY_LEFT: if (selection > 0) selection--; break;
				case KEY_RIGHT: if (selection < 3) selection++; break;
				case KEY_ENTER:
					switch (selection)
					{
						case 0: Practice(); break;
						case 1: RandomGame(); break;
						case 2: ShowArcadeGames(); break;
						case 3: DrawTextBox(SW/2-120, 20, 240, 16, "Feature not yet implemented, sorry!"); DrawGameModes(); break;
					}
				break;
			}
		}
	}
	GameMenu.draw();
	return 0;
}

function Credits()
{
	CreditPlane.fadeImage("in");
	while(!IsKeyPressed(KEY_ESCAPE))
	{
		BG1.update(2000);
		BG2.update(2000);
		Screen.blit(0, 0);
		Squared.blit(SW/2-Squared.width/2, 48);
		CreditPlane.update(1200);
		FlipScreen();
	}
	CreditPlane.fadeImage("out");
	do
	{
		BG1.update(2000);
		BG2.update(2000);
		Screen.blit(0, 0);
		Squared.blit(SW/2-Squared.width/2, 48);
		CreditPlane.update(1200);
		FlipScreen();
	}while(CreditPlane.time + 1200 > GetTime())
	GameMenu.draw();
}